/*
 * @(#)RERLiveConnectApplet.java  1.0.1  2007-02-15
 *
 * Copyright (c) 2006-2007 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.rer;

import ch.hslu.cm.ComparisonPane;
import ch.hslu.cm.SolutionPane;
import com.sun.security.auth.SolarisPrincipal;
import netscape.javascript.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import org.jhotdraw.draw.TextFigure;
/**
 * RERLiveConnectApplet.
 * Supports loading and saving of ER diagrams to JavaScript.
 *
 *
 * @author Werner Randelshofer
 * @version 1.0.1 2007-02-15 Reset did only reset to the last saved-point,
 * but it should reset to the initial state of the applet.
 * <br>1.0 2006-02-02 Created.
 */
public class RERLiveConnectApplet extends RERApplet {
    private SolutionPane solutionPane;
    private ComparisonPane verifyPane;
    
    /**
     * The autosaver saves the data one second after the last change has
     * been made by the user.
     */
    private class Autosaver implements UndoableEditListener, ActionListener {
        private boolean isSaved;
        public void undoableEditHappened(UndoableEditEvent evt) {
            isSaved = false;
            saveButton.setEnabled(true);
            Timer t = new Timer(1000, this);
            t.setRepeats(false);
            t.start();
        }
        public void actionPerformed(ActionEvent evt) {
            if (!isSaved) {
                save(evt);
                isSaved = true;
                saveButton.setEnabled(false);
            }
        }
    }
    private Autosaver autosaver;
    
    /**
     * Does additional initialisation steps.
     */
    protected void initAdditional() {
        initComponents();
        
        if (solutionPane != null && solutionPane.isShowing()) {
            solutionPane.close();
        }
        if (verifyPane != null && verifyPane.isShowing()) {
            verifyPane.close();
        }
        
        loadButton.setVisible(false);
        saveButton.setVisible(false);
        loadButton.setEnabled(false);
        saveButton.setEnabled(false);
        
        try {
            // Check if LiveConnect is available
            boolean isLiveConnect;
            try {
                Class.forName("netscape.javascript.JSObject");
                isLiveConnect = true;
            } catch (Throwable t) {
                isLiveConnect = false;
            }
            
            // Check if read and write method names have been specified
            String readMethodName = getParameter("dataread");
            String writeMethodName = getParameter("datawrite");
            
            // Read data from JavaScript
            if (isLiveConnect && readMethodName != null) {
                if (readMethodName.indexOf('(') > 0) {
                    readMethodName = readMethodName.substring(0, readMethodName.indexOf('(') - 1);
                }
                try {
                    JSObject win = JSObject.getWindow(this);
                    Object data = win.call(readMethodName, new Object[0]);
                    if (data instanceof String && ((String) data).length() > 0) {
                        setData((String) data);
                    }
                } catch (Throwable e) {
                    e.printStackTrace();
                    isLiveConnect = false;
                    throw new IllegalArgumentException(labels.getString("appletErrorNoLiveConnect"));
                }
            }
            
            // Initialize autosave feature
            String value = getParameter("autosave");
            boolean isAutosave = value != null && value.equals("true");
            if (isAutosave && (writeMethodName == null || readMethodName == null)) {
                throw new IllegalArgumentException("Error: 'autosave' requires that 'dataread' and 'datawrite' parameters are specified.");
            }
            if (isLiveConnect) {
                if (isAutosave) {
                    autosaver = new Autosaver();
                    getDrawing().addUndoableEditListener(autosaver);
                } else {
                    // Set button states depending on availabability of LiveConnect and
                    // on presence of method names.
                    loadButton.setEnabled(readMethodName != null);
                    saveButton.setEnabled(writeMethodName != null);
                    
                }
            }
            
            
        } catch (IllegalArgumentException e) {
            // Show error message, if we can't provide a specific feature
            JLabel lcMissingLabel = new JLabel(e.getMessage());
            lcMissingLabel.setBackground(Color.yellow);
            lcMissingLabel.setOpaque(true);
            getContentPane().add(lcMissingLabel, BorderLayout.NORTH);
        }
        
        loadButton.setOpaque(false);
        saveButton.setOpaque(false);
        resetButton.setOpaque(false);
        showSolutionButton.setOpaque(false);
        verifyButton.setOpaque(false);
        liveConnectToolbar.putClientProperty("css.class","toolbar");
    }
    
    
    
    public String[][] getParameterInfo() {
        return new String[][] {
            { "data", "String", "the data to be displayed by this applet." },
            { "datafile", "URL", "an URL to the data to be displayed by this applet." },
            { "dataread", "function()", "the name of a JavaScript function which can be used to read the data." },
            { "datawrite", "function()", "the name of a JavaScript function which can be used to write the data." },
            { "autosave", "boolean", "set this to true, to have the applet automatically invoke the dataread and datawrite functions." }
        };
    }
    
    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        liveConnectToolbar = new javax.swing.JToolBar();
        loadButton = new javax.swing.JButton();
        saveButton = new javax.swing.JButton();
        stretcherPanel = new javax.swing.JPanel();
        resetButton = new javax.swing.JButton();
        verifyButton = new javax.swing.JButton();
        showSolutionButton = new javax.swing.JButton();

        liveConnectToolbar.setFloatable(false);
        loadButton.setText(labels.getString("appletLoad"));
        loadButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                load(evt);
            }
        });

        liveConnectToolbar.add(loadButton);

        saveButton.setText(labels.getString("appletSave"));
        saveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                save(evt);
            }
        });

        liveConnectToolbar.add(saveButton);

        stretcherPanel.setOpaque(false);
        liveConnectToolbar.add(stretcherPanel);

        resetButton.setText(labels.getString("appletReset"));
        resetButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                reset(evt);
            }
        });

        liveConnectToolbar.add(resetButton);

        verifyButton.setText(labels.getString("appletVerify"));
        verifyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                verify(evt);
            }
        });

        liveConnectToolbar.add(verifyButton);

        showSolutionButton.setText(labels.getString("appletShowSolution"));
        showSolutionButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showSolution(evt);
            }
        });

        liveConnectToolbar.add(showSolutionButton);

        getContentPane().add(liveConnectToolbar, java.awt.BorderLayout.SOUTH);

    }// </editor-fold>//GEN-END:initComponents
    
    private void showSolution(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showSolution
        if (solutionPane == null) {
            solutionPane = new SolutionPane();
            solutionPane.setDrawing(solutionDiagram);
        }
        if (! solutionPane.isShowing()) {
            JComponent drawingContainer = getDrawingView().getComponent();
            Rectangle dcBounds = SwingUtilities.convertRectangle(drawingContainer.getParent(), drawingContainer.getBounds(), this);
            getRootPane().getLayeredPane().add(solutionPane, JLayeredPane.MODAL_LAYER);
            solutionPane.setBounds(dcBounds.x, dcBounds.y, dcBounds.width, dcBounds.height);
            solutionPane.setVisible(true);
            solutionPane.revalidate();
        }
    }//GEN-LAST:event_showSolution
    
    private void verify(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_verify
        if (verifyPane == null) {
            verifyPane = new ComparisonPane();
            verifyPane.addMouseListener(new MouseAdapter() {});
            verifyPane.addMouseMotionListener(new MouseMotionAdapter() {});
            if (stylesheet != null) {
                verifyPane.setStylesheet(stylesheet);
            }
        }
        java.util.List<String> differences = problemDiagram.getERModel().describeDifferencesTo(solutionDiagram.getERModel());
        String text;
        if (differences.size() == 0) {
            text = labels.getString("noDiffsFound");
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append("<html>");
            buf.append("<ul>");
            for (String str : differences) {
                buf.append("<li>");
                buf.append(str);
                buf.append("</li>");
            }
            buf.append("</ul>");
            text = buf.toString();
        }
        verifyPane.setText(text);
        
        if (! verifyPane.isShowing()) {
            getRootPane().getLayeredPane().add(verifyPane, JLayeredPane.MODAL_LAYER);
            JComponent drawingContainer = getDrawingView().getComponent();
            Rectangle dcBounds = SwingUtilities.convertRectangle(drawingContainer.getParent(), drawingContainer.getBounds(), this);
            verifyPane.setBounds(
                    (int) (dcBounds.x + dcBounds.width * 0.5), 
                    (int) (dcBounds.y + dcBounds.height * 0.5),
                    (int) (dcBounds.width * 0.5),
                    (int) (dcBounds.height * 0.5)
                    );
            verifyPane.revalidate();
        }
            verifyPane.scrollTextVisible();
        
    }//GEN-LAST:event_verify
    
    private void reset(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_reset
        try {
            String methodName = getParameter("datawrite");
            if (methodName != null) {
                if (methodName.indexOf('(') > 0) {
                    methodName = methodName.substring(0, methodName.indexOf('(') - 1);
                }
                JSObject win = JSObject.getWindow(this);
                Object result = win.call(methodName, new Object[] { "" });
            }
        } catch (Throwable t) {
            TextFigure tf = new TextFigure("Fehler: "+t);
            AffineTransform tx = new AffineTransform();
            tx.translate(10, 20);
            tf.transform(tx);
            getDrawing().add(tf);
        }
        reset();
    }//GEN-LAST:event_reset
    
    private void save(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_save
        try {
            String methodName = getParameter("datawrite");
            if (methodName != null) {
                if (methodName.indexOf('(') > 0) {
                    methodName = methodName.substring(0, methodName.indexOf('(') - 1);
                }
                JSObject win = JSObject.getWindow(this);
                Object result = win.call(methodName, new Object[] { getData() });
            }
        } catch (Throwable t) {
            TextFigure tf = new TextFigure("Fehler: "+t);
            AffineTransform tx = new AffineTransform();
            tx.translate(10, 20);
            tf.transform(tx);
            getDrawing().add(tf);
        }
    }//GEN-LAST:event_save
    
    private void load(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_load
        try {
            String methodName = getParameter("dataread");
            if (methodName != null) {
                if (methodName.indexOf('(') > 0) {
                    methodName = methodName.substring(0, methodName.indexOf('(') - 1);
                }
                JSObject win = JSObject.getWindow(this);
                Object result = win.call(methodName, new Object[0]);
                if (result instanceof String) {
                    setData((String) result);
                }
            }
        } catch (Throwable t) {
            TextFigure tf = new TextFigure(labels.getFormatted("error", t.toString()));
            AffineTransform tx = new AffineTransform();
            tx.translate(10, 20);
            tf.transform(tx);
            getDrawing().add(tf);
        }
        
    }//GEN-LAST:event_load
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JToolBar liveConnectToolbar;
    private javax.swing.JButton loadButton;
    private javax.swing.JButton resetButton;
    private javax.swing.JButton saveButton;
    private javax.swing.JButton showSolutionButton;
    private javax.swing.JPanel stretcherPanel;
    private javax.swing.JButton verifyButton;
    // End of variables declaration//GEN-END:variables
    
}
